/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.v1_14_R1;

import com.andavin.reflect.Reflection;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.DataWatcherObject;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityItemFrame;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.IMaterial;
import net.minecraft.server.v1_14_R1.ItemStack;
import net.minecraft.server.v1_14_R1.Items;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_14_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_14_R1.PacketPlayOutMap;
import net.minecraft.server.v1_14_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_14_R1.PlayerConnection;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

class MapHelper
extends com.andavin.images.MapHelper {
    static final int DEFAULT_STARTING_ID = 1000000;
    private static final Field ENTITY_ID = Reflection.findField(Entity.class, "id");
    private static final DataWatcherObject<Integer> ROTATION = (DataWatcherObject)Reflection.getFieldValue(EntityItemFrame.class, null, "g");
    private static final Map<UUID, AtomicInteger> MAP_IDS = new HashMap<UUID, AtomicInteger>(4);

    MapHelper() {
    }

    @Override
    protected MapView getWorldMap(int id) {
        return Bukkit.getMap((int)id);
    }

    @Override
    protected int nextMapId(org.bukkit.World world) {
        return MAP_IDS.computeIfAbsent(world.getUID(), __ -> new AtomicInteger(1000000)).getAndIncrement();
    }

    @Override
    protected void createMap(int frameId, int mapId, Player player, Location location, BlockFace direction, int rotation, byte[] pixels) {
        ItemStack item = new ItemStack((IMaterial)Items.FILLED_MAP);
        item.getOrCreateTag().setInt("map", mapId);
        EntityItemFrame frame = new EntityItemFrame((World)((CraftWorld)player.getWorld()).getHandle(), new BlockPosition(location.getX(), location.getY(), location.getZ()), CraftBlock.blockFaceToNotch((BlockFace)direction));
        frame.setItem(item, false, false);
        Reflection.setFieldValue(ENTITY_ID, frame, frameId);
        if (rotation != 0) {
            frame.getDataWatcher().set(ROTATION, (Object)rotation);
        }
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        connection.sendPacket((Packet)new PacketPlayOutSpawnEntity((Entity)frame, EntityTypes.ITEM_FRAME, frame.getDirection().a(), frame.getBlockPosition()));
        connection.sendPacket((Packet)new PacketPlayOutEntityMetadata(frame.getId(), frame.getDataWatcher(), true));
        connection.sendPacket((Packet)new PacketPlayOutMap(mapId, 3, false, false, Collections.emptyList(), pixels, 0, 0, 128, 128));
    }

    @Override
    protected void destroyMap(Player player, int[] frameIds) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(frameIds));
    }

    @Override
    protected byte[] createPixels(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        int[] pixels = new int[pixelCount];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        byte[] colors = new byte[pixelCount];
        for (int i = 0; i < pixelCount; ++i) {
            colors[i] = MapPalette.matchColor((Color)new Color(pixels[i], true));
        }
        return colors;
    }
}

